<?php namespace DistrictHub\Api\Http\Controllers;

use DistrictHub\Directory\Member;
use App\Http\Controllers\Controller;
use App\Http\Requests;
use Illuminate\Http\Request;

class MemberController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index(Request $request)
    {
        $name = $request->input('name');
        $circuitId = $request->input('circuit_id');

        $members = Member::where(function ($query) use ($name) {
            return $query->where('first_name', 'LIKE', "$name%")->orWhere('last_name', 'LIKE', "$name%");
        });

        if (!is_null($circuitId))
        {
            $members = $members->where('circuit_id', $circuitId);
        }

        $members = $members->get();

        return response()->json(['data' => $members]);
    }
}
