<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

//// Authentication Routes...
$this->get('auth/login', 'AuthController@getLogin')->name('login');
$this->post('auth/login', 'AuthController@postLogin');
$this->post('auth/logout', 'AuthController@logout')->name('logout');
//
//// Registration Routes...
//$this->get('register', 'RegisterController@showRegistrationForm')->name('register');
//$this->post('register', 'RegisterController@register');
//
//// Password Reset Routes...
//$this->get('password/reset', 'ForgotPasswordController@showLinkRequestForm')->name('password.request');
//$this->post('password/email', 'ForgotPasswordController@sendResetLinkEmail')->name('password.email');
//$this->get('password/reset/{token}', 'ResetPasswordController@showResetForm')->name('password.reset');
//$this->post('password/reset', 'ResetPasswordController@reset');

Route::get('profile', ['as' => 'profile.edit', 'uses' => 'ProfileController@edit']);
Route::patch('profile', ['as' => 'profile.update', 'uses' => 'ProfileController@update']);
Route::patch('profile/member/{members}', ['as' => 'profile.member', 'uses' => 'ProfileController@member']);
Route::patch('profile/password', ['as' => 'profile.change', 'uses' => 'ProfileController@change']);

Route::get('permissions', [
    'as'   => 'permissions.index',
    'uses' => 'PermissionController@index',
]);

Route::post('permissions', [
    'as'   => 'permissions.store',
    'uses' => 'PermissionController@store',
]);

Route::get('permissions/delete', [
    'as'   => 'permissions.destroy',
    'uses' => 'PermissionController@destroy',
]);

Route::get('activation', [
    'as'   => 'activation.update',
    'uses' => 'ActivationController@update',
]);

