<?php namespace DistrictHub\Auth\Http\Controllers;

use App\Http\Controllers\Controller;
use DistrictHub\Auth\Http\Requests\PasswordRequest;
use DistrictHub\Auth\Http\Requests\ProfileRequest;
use DistrictHub\Auth\Jobs\ChangePassword;
use DistrictHub\Auth\Jobs\UpdateProfile;
use DistrictHub\Directory\Jobs\UpdateMember;
use DistrictHub\Directory\MemberTitle;
use DistrictHub\Directory\Http\Requests\MemberProfileRequest;
use Illuminate\Contracts\Auth\Authenticatable;

class ProfileController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Profile Controller
    |--------------------------------------------------------------------------
    */

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @return Response
     */
    public function edit(Authenticatable $user)
    {
        $titles = MemberTitle::all()->pluck('description', 'description');

        return view('auth::profile.edit', compact('user', 'titles'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @return Response
     */
    public function update(ProfileRequest $request, Authenticatable $user)
    {
        $this->dispatch(new UpdateProfile($user->id, $request->all()));

        return redirect()->back();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function member($id, MemberProfileRequest $request)
    {
        $this->dispatch(new UpdateMember($id, $request->all()));

        return redirect()->back();
    }

    /**
     * Update the specified resource in storage.
     *
     * @return Response
     */
    public function change(PasswordRequest $request, Authenticatable $user)
    {
        $this->dispatch(new ChangePassword($user->id, $request->input('password')));

        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        //
    }
}
