<?php namespace DistrictHub\Auth\Listeners;

use App\Events\ProfileWasUpdated;
use DistrictHub\Support\Listeners\Notification;

class AlertProfileUpdated extends Notification
{
    /**
     * Handle the event.
     *
     * @param  ProfileWasUpdated $event
     *
     * @return void
     */
    public function handle(ProfileWasUpdated $event)
    {
        $this->notifier->success("Updated your profile \"{$event->user->name}\"");
    }
}
