@extends('auth')

@section('content')
<div class="container-fluid">
	<div class="row">
		<div class="col-md-8 col-md-offset-2">
			<div class="panel panel-default">
				<div class="panel-heading">Register</div>
				<div class="panel-body">
                    @if (session('status'))
                        <div class="alert alert-success">
                            {{ session('status') }}
                        </div>
                    @endif

					@if (count($errors) > 0)
						<div class="alert alert-danger">
							<strong>Whoops!</strong> There were some problems with your input.<br><br>
							<ul>
								@foreach ($errors->all() as $error)
									<li>{{ $error }}</li>
								@endforeach
							</ul>
						</div>
					@endif

                    {!! Form::open(['class' => 'form-horizontal', 'method' => 'POST', 'url' => '/auth/register']) !!}
						{!! Form::hidden('_token', csrf_token()) !!}

                        @if(isset($members))
                            <div class="form-group">
                                {!! Form::label('member', 'Member', ['class' => 'col-md-4 control-label']) !!}
                                <div class="col-md-6">
                                    {!! Form::select('member', $members, old('member'), ['class' => 'form-control']) !!}
                                </div>
                            </div>
                            <div class="form-group">
                                {!! Form::label('username', 'Username', ['class' => 'col-md-4 control-label']) !!}
                                <div class="col-md-6">
                                    {!! Form::text('username', old('username'), ['class' => 'form-control']) !!}
                                </div>
                            </div>
                        @else
                            <div class="form-group">
                                {!! Form::label('email', 'Email', ['class' => 'col-md-4 control-label']) !!}
                                <div class="col-md-6">
                                    {!! Form::text('email', Request::input('email'), ['class' => 'form-control']) !!}
                                </div>
                            </div>
                        @endif

						<div class="form-group">
							<div class="col-md-6 col-md-offset-4">
                                {!! Form::button('Register', ['class' => 'btn btn-primary', 'type' => 'submit']) !!}
							</div>
						</div>
					{!! Form::close() !!}
				</div>
			</div>
		</div>
	</div>
</div>
@endsection
