<?php namespace DistrictHub\Auth\Http\Controllers;

use App\Http\Controllers\Controller;
use DistrictHub\Auth\Services\Activation;
use DistrictHub\Auth\Exceptions\UserAlreadyActiveException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Laracasts\Flash\Flash;

class ActivationController extends Controller
{
    /**
     * Update the specified resource in storage.
     *
     * @return Response
     */
    public function update(Request $request, Activation $activation)
    {
        // Get the user ID
        $userId = $request->get('user_id');

        try {
            // Resend activation
            $activation->resend($userId);
        } catch (ModelNotFoundException $exception) {
            // Send HTTP exception
            abort(500, $exception->getMessage());
        } catch (UserAlreadyActiveException $exception) {
            // Send HTTP exception
            abort(500, $exception->getMessage());
        }

        // Notify the user of success
        Flash::success('Resent activation link to user');

        // Redirect back
        return redirect()->back();
    }
}
