<?php namespace DistrictHub\Auth\Jobs;

use DistrictHub\Auth\Events\PasswordWasChanged;
use DistrictHub\Auth\User;
use DistrictHub\Support\Jobs\Job;
use Illuminate\Contracts\Bus\SelfHandling;

class ChangePassword extends Job implements SelfHandling
{
    protected $userId, $password;

    /**
     * Create a new command instance.
     *
     * @param $userId
     * @param $password
     */
    public function __construct($userId, $password)
    {
        $this->userId = $userId;
        $this->password = $password;
    }

    /**
     * Execute the command.
     *
     * @return void
     */
    public function handle()
    {
        $user = User::find($this->userId);

        $password = bcrypt($this->password);

        $user->update(['password' => $password]);

        event(new PasswordWasChanged($user));
    }
}
