<?php namespace DistrictHub\Auth\Jobs;

use DistrictHub\Auth\Events\ProfileWasUpdated;
use DistrictHub\Auth\User;
use DistrictHub\Support\Jobs\Job;
use Illuminate\Contracts\Bus\SelfHandling;

class UpdateProfile extends Job implements SelfHandling
{
    protected $id, $attributes;

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct($id, array $attributes)
    {
        $this->id = $id;
        $this->attributes = $attributes;
    }

    /**
     * Execute the command.
     *
     * @return void
     */
    public function handle()
    {
        $user = User::find($this->id);

        $user->update($this->attributes);

        event(new ProfileWasUpdated($user));
    }
}
