@extends('app')

@section('title')
    <h2>Profile</h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li class="active">Profile</li>
    </ol>
@stop

@section('content')

    @if($user->member)
        <div class="panel panel-default">
            <div class="panel-heading">Personal Details</div>
            <div class="panel-body">
                @include('auth::profile.panels.member-personal-details', ['member' => $user->member])
            </div>
        </div>

        <div class="panel panel-default">
            <div class="panel-heading">Role Details</div>
            <div class="panel-body">
                @include('directory::members.panels.role-details', ['member' => $user->member])
            </div>
        </div>

        <div class="panel panel-default">
            <div class="panel-heading">Contact Details</div>
            <div class="panel-body">
                @include('directory::members.panels.contact-details', ['member' => $user->member])
            </div>
        </div>
    @else
        <div class="panel panel-default">
            <div class="panel-heading">Personal Details</div>
            <div class="panel-body">
                @include('auth::profile.panels.personal-details')
            </div>
        </div>
    @endif

    <div class="panel panel-default">
        <div class="panel-heading">Change Password</div>
        <div class="panel-body">
            @include('auth::profile.panels.change-password')
        </div>
    </div>

@endsection