<?php namespace DistrictHub\Auth\Providers;

use DistrictHub\Auth\Events\PasswordWasChanged;
use DistrictHub\Auth\Events\ProfileWasUpdated;
use DistrictHub\Auth\Listeners\AlertPasswordChanged;
use DistrictHub\Auth\Listeners\AlertProfileUpdated;
use Illuminate\Contracts\Events\Dispatcher as DispatcherContract;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event handler mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        ProfileWasUpdated::class  => [
            AlertProfileUpdated::class,
        ],
        PasswordWasChanged::class => [
            AlertPasswordChanged::class,
        ],
    ];
}
