@extends('app')

@section('title')
    <h2>
        Security
    </h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li class="active">Security</li>
    </ol>
@stop

@section('content')
    <div class="panel panel-default">
        <div class="panel-heading">Administrators</div>
        <div class="panel-body">
            {!! Form::open(['method' => 'POST', 'route' => ['permissions.store']]) !!}
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group{{ $errors->has('user_id') ? ' has-error' : '' }} flush-bottom">
                        {!! Form::hidden('role_id', 1) !!}
                        {!! Form::text('user_id', null, ['id' => 'admin_user_id', 'class' => 'form-control', 'placeholder' => 'Search for user...']) !!}
                        @if($errors->has('user_id'))
                            <span class="text-danger">{{ $errors->first('user_id') }}</span>
                        @endif
                    </div>
                </div>
                <div class="col-md-9">
                    {!! Form::button('Add', ['class' => 'btn btn-primary flush-bottom', 'type' => 'submit']) !!}
                </div>
            </div>
            {!! Form::close() !!}
        </div>
        <div class="table-responsive">
            <table id="admin-table" class="table table table-striped table-bordered table-hover display" cellspacing="0" width="100%">
                <thead>
                <tr>
                    <th>Name</th>
                    <th>Last Updated</th>
                    <th></th>
                </tr>
                </thead>

                @foreach($admins as $user)
                    <tr>
                        <td>{{ $user->name }}</td>
                        <td>{{ $user->updated_at }}</td>
                        <td data-display="{{ $user->member_id }}">
                            @if($user->member_id)
                            <a class="btn btn-default btn-xs" href="{{ route('members.show', ['id' => $user->member_id]) }}" data-toggle="tooltip" data-placement="top" title="View member">
                                <i class="fa fa-eye"></i>
                            </a>
                            @if(Auth::user()->ability('district-admin', 'edit-member'))
                                <a class="btn btn-primary btn-xs" href="{{ route('members.edit', ['id' => $user->member_id]) }}" data-toggle="tooltip" data-placement="top" title="Edit member">
                                    <i class="fa fa-pencil"></i>
                                </a>
                            @endif
                            @endif
                            <a href="{{ route('permissions.destroy', ['user_id' => $user->id, 'role_id' => 1]) }}" class="btn btn-danger btn-xs" data-toggle="tooltip" data-placement="top" title="Remove user">
                                <i class="fa fa-trash"></i>
                            </a>
                        </td>
                    </tr>
                @endforeach
            </table>
        </div>
    </div>

    <div class="panel panel-default">
        <div class="panel-heading">Officers</div>
        <div class="panel-body">
            {!! Form::open(['method' => 'POST', 'route' => ['permissions.store']]) !!}
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group{{ $errors->has('user_id') ? ' has-error' : '' }} flush-bottom">
                        {!! Form::hidden('role_id', 2) !!}
                        {!! Form::text('user_id', null, ['id' => 'officer_user_id', 'class' => 'form-control', 'placeholder' => 'Search for user...']) !!}
                        @if($errors->has('user_id'))
                            <span class="text-danger">{{ $errors->first('user_id') }}</span>
                        @endif
                    </div>
                </div>
                <div class="col-md-9">
                    {!! Form::button('Add', ['class' => 'btn btn-primary flush-bottom', 'type' => 'submit']) !!}
                </div>
            </div>
            {!! Form::close() !!}
        </div>
        <div class="table-responsive">
            <table id="officer-table" class="table table table-striped table-bordered table-hover display" cellspacing="0" width="100%">
                <thead>
                <tr>
                    <th>Name</th>
                    <th>Last Updated</th>
                    <th></th>
                </tr>
                </thead>

                @foreach($officers as $user)
                    <tr>
                        <td>{{ $user->name }}</td>
                        <td>{{ $user->updated_at }}</td>
                        <td data-display="{{ $user->member_id }}">
                            @if($user->member_id)
                            <a class="btn btn-default btn-xs" href="{{ route('members.show', ['id' => $user->member_id]) }}" data-toggle="tooltip" data-placement="top" title="View member">
                                <i class="fa fa-eye"></i>
                            </a>
                            @if(Auth::user()->ability('district-admin', 'edit-member'))
                                <a class="btn btn-primary btn-xs" href="{{ route('members.edit', ['id' => $user->member_id]) }}" data-toggle="tooltip" data-placement="top" title="Edit member">
                                    <i class="fa fa-pencil"></i>
                                </a>
                            @endif
                            @endif
                            <a href="{{ route('permissions.destroy', ['user_id' => $user->id, 'role_id' => 2]) }}" class="btn btn-danger btn-xs" data-toggle="tooltip" data-placement="top" title="Remove user">
                                <i class="fa fa-trash"></i>
                            </a>
                        </td>
                    </tr>
                @endforeach
            </table>
        </div>
    </div>

    <div class="page-header">
        <h2>Manage user registration</h2>
    </div>

    <div class="panel panel-default">
        <div class="panel-heading">User accounts awaiting activation</div>
        <div class="table-responsive">
            <table id="users-table" class="table table table-striped table-bordered table-hover display" cellspacing="0" width="100%">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Activation Expires</th>
                        <th></th>
                    </tr>
                </thead>

                @foreach($users as $user)
                    <tr>
                        <td>{{ $user->name }}</td>
                        <td>{{ $user->email }}</td>
                        <td class="{{ $user->activation_link_expired ? 'text-danger' : 'text-success' }}">{{ $user->activation_link_expires_at }}</td>
                        <td data-display="{{ $user->member_id }}">
                            @if($user->member_id)
                                <a class="btn btn-default btn-xs" href="{{ route('members.show', ['id' => $user->member_id]) }}" data-toggle="tooltip" data-placement="top" title="View member">
                                    <i class="fa fa-eye"></i>
                                </a>
                                @if(Auth::user()->ability('district-admin', 'edit-member'))
                                    <a class="btn btn-primary btn-xs" href="{{ route('members.edit', ['id' => $user->member_id]) }}" data-toggle="tooltip" data-placement="top" title="Edit member">
                                        <i class="fa fa-pencil"></i>
                                    </a>
                                @endif
                            @endif
                            <a href="{{ route('activation.update', ['user_id' => $user->id]) }}" class="btn btn-warning btn-xs" data-toggle="tooltip" data-placement="top" title="Resend activation link">
                                <i class="fa fa-paper-plane-o"></i>
                            </a>
                        </td>
                    </tr>
                @endforeach
            </table>
        </div>
    </div>

    <div class="page-header">
        <h2>Manage consent for GDPR</h2>
    </div>

    <div class="panel panel-default">
        <div class="panel-heading">Members without valid consent</div>
        <div class="table-responsive">
            <table id="users-table" class="table table table-striped table-bordered table-hover display" cellspacing="0" width="100%">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Authority Expired</th>
                        <th></th>
                    </tr>
                </thead>

                @foreach($members as $member)
                    <tr>
                        <td>{{ $member->name }}</td>
                        <td>
                            @if(isset($member->primary_email))
                                {{ $member->primary_email->address }}
                            @endif
                        </td>
                        @if($member->gdpr_authorized_at && $member->gdpr_authorized_at->addMonths(12)->lessThan(Carbon\Carbon::now()))
                            <td class="text-danger">{{ $member->gdpr_authorized_at }}</td>
                        @elseif(!$member->gdpr_authorized_at)
                            <td class="text-danger">N/A</td>
                        @else($member->gdpr_authorized_at)
                            <td>{{ $member->gdpr_authorized_at }}</td>
                        @endif
                        <td data-display="{{ $member->id }}">
                            <a class="btn btn-default btn-xs" href="{{ route('members.show', ['id' => $member->id]) }}" data-toggle="tooltip" data-placement="top" title="View member">
                                <i class="fa fa-eye"></i>
                            </a>
                            @if(Auth::user()->ability('district-admin', 'edit-member'))
                                <a class="btn btn-primary btn-xs" href="{{ route('members.edit', ['id' => $member->id]) }}" data-toggle="tooltip" data-placement="top" title="Edit member">
                                    <i class="fa fa-pencil"></i>
                                </a>
                            @endif
                            <a href="{{ route('members.gdpr.create', ['id' => $member->id]) }}" class="btn btn-success btn-xs" data-toggle="tooltip" data-placement="top" title="Update consent">
                                <i class="fa fa-check"></i>
                            </a>
                        </td>
                    </tr>
                @endforeach
            </table>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $('#admin_user_id,#officer_user_id').selectize({
            maxItems: 1,
            valueField: 'id',
            labelField: 'name',
            searchField: 'name',
            sortField: 'name',
            create: false,
            render: {
                option: function (item, escape) {
                    return '<div>' +
                            '<span class="">' + escape(item.name) + '</span><br>' +
                            '</div>';
                }
            },
            load: function (query, callback) {
                if(!query.length) return callback();
                $.ajax({
                    url: '{{ route('api.users.index') }}',
                    type: 'GET',
                    dataType: 'json',
                    error: function () {
                        callback();
                    },
                    success: function (response) {
                        callback(response.data)
                    }
                });
            }
        });

        $('[data-toggle="tooltip"]').tooltip();
    </script>
@stop
