<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

// Authentication Routes...
Route::get('auth/login', 'AuthController@getLogin')->name('login');
Route::post('auth/login', 'AuthController@postLogin');
Route::get('auth/logout', 'AuthController@getLogout')->name('logout');

// Registration Routes...
Route::get('auth/register', 'AuthController@getRegister')->name('register');
Route::post('auth/register', 'AuthController@postRegister');

// Activation Routes...
Route::get('auth/activate/{token}', 'AuthController@getActivate')->name('activate');
Route::post('auth/activate', 'AuthController@postActivate');

// Password Reset Routes...
Route::get('password/email', 'PasswordController@getEmail');
Route::post('password/email', 'PasswordController@postEmail')->name('password.email');
Route::get('password/reset/{token}', 'PasswordController@getReset')->name('password.reset');
Route::post('password/reset', 'PasswordController@postReset');

Route::get('profile', ['as' => 'profile.edit', 'uses' => 'ProfileController@edit']);
Route::patch('profile', ['as' => 'profile.update', 'uses' => 'ProfileController@update']);
Route::patch('profile/member/{members}', ['as' => 'profile.member', 'uses' => 'ProfileController@member']);
Route::patch('profile/password', ['as' => 'profile.change', 'uses' => 'ProfileController@change']);

Route::get('permissions', [
    'as'   => 'permissions.index',
    'uses' => 'PermissionController@index',
]);

Route::post('permissions', [
    'as'   => 'permissions.store',
    'uses' => 'PermissionController@store',
]);

Route::get('permissions/delete', [
    'as'   => 'permissions.destroy',
    'uses' => 'PermissionController@destroy',
]);

Route::get('activation', [
    'as'   => 'activation.update',
    'uses' => 'ActivationController@update',
]);
