<?php namespace DistrictHub\Auth\Exceptions;

use DistrictHub\Auth\User;
use RuntimeException;

/**
 * Runtime exception to handle instances of a user already being active.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 */
class UserAlreadyActiveException extends RuntimeException
{
    /**
     * Name of the affected User model.
     *
     * @var string
     */
    protected $user;

    /**
     * Set the affected User model.
     *
     * @param  User $user
     *
     * @return $this
     */
    public function setUser(User $user)
    {
        $this->user = $user;

        $this->message = "User '{$user->name}' has already activated their account.";

        return $this;
    }

    /**
     * Get the affected User model.
     *
     * @return string
     */
    public function getUser()
    {
        return $this->user;
    }
}
