<?php namespace DistrictHub\Auth\Http\Requests;


use Illuminate\Foundation\Http\FormRequest;

class RegisterRequest extends FormRequest {

	/**
	 * Determine if the user is authorized to make this request.
	 *
	 * @return bool
	 */
	public function authorize()
	{
		return true;
	}

	/**
	 * Get the validation rules that apply to the request.
	 *
	 * @return array
	 */
	public function rules()
	{
		return [
            'email'    => 'sometimes|required|email|max:255|unique:users,username|exists:directory_emails,address',
            'username' => 'sometimes|required|min:3|max:255|unique:users,username',
		];
	}

    /**
     * Get the validation messages that apply to the rules for this request.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'email.exists'    => 'There is no member record with that email address.',
            'email.unique'    => 'There is already an account with that email address.',
            'username.unique' => 'There is already an account with that username.',
        ];
    }

}
