<?php namespace DistrictHub\Auth\Http\Controllers;

use DistrictHub\Auth\Role;
use DistrictHub\Auth\Services\Activation;
use DistrictHub\Auth\User;
use App\Http\Controllers\Controller;
use DistrictHub\Directory\Member;
use Flash;

class PermissionController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Permission Controller
    |--------------------------------------------------------------------------
    */

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index(Activation $activation)
    {
        $admins = Role::where('name', 'district-admin')->firstOrFail()->users;
        $officers = Role::where('name', 'district-officer')->firstOrFail()->users;
        $users = $activation->usersWithExpiredTokens();
        $members = Member::withoutValidGdprRecord()->orderBy('last_name')->get();

        return view('auth::permissions.index', compact('admins', 'officers', 'users', 'members'));
    }

    public function store(\DistrictHub\Auth\Http\Requests\PermissionRequest $request)
    {
        $user_id = $request->input('user_id');
        $role_id = $request->input('role_id');

        $user = User::findOrFail($user_id);

        $user->roles()->attach($role_id);

        Flash::success("Added user to security group");

        return redirect()->back();
    }

    public function destroy(\DistrictHub\Auth\Http\Requests\PermissionRequest $request)
    {
        $user_id = $request->input('user_id');
        $role_id = $request->input('role_id');

        $user = User::findOrFail($user_id);

        $user->roles()->detach($role_id);

        Flash::success("Removed user from security group");

        return redirect()->back();
    }
}
