<?php namespace DistrictHub\Contracts\Gateways\Directory;

/**
 * CircuitGateway.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 * @package      App\Gateways\Directory
 */
interface CircuitGateway
{
    /**
     * Search records with fields and sort with order.
     *
     * @param array $fields
     * @param array $order
     *
     * @return \Illuminate\Database\Eloquent\Collection|static[]
     */
    public function search(array $fields, array $order);

    /**
     * Get the total number of records.
     *
     * @return int
     */
    public function total();

    /**
     * Find a model by its primary key.
     *
     * @param  mixed $id
     *
     * @return \DistrictHub\Directory\Circuit|null
     */
    public function find($id);

    /**
     * Update a model with the specified primary key.
     *
     * @param int   $id
     * @param array $attributes
     *
     * @return bool
     */
    public function update($id, array $attributes);

    /**
     * Get array of ids/values for use in select fields.
     *
     * @param string $valueColumn
     * @param string $idColumn
     * @param string $default
     *
     * @return array
     */
    public function options($valueColumn, $idColumn = 'id', $default = '-- Select --');
}
