@extends('app')

@section('title')
    <h2>
        {{ $church->name }}
        <a class="btn btn-default pull-right" href="{{ route('churches.show', ['id' => $church->id]) }}">
            <i class="fa fa-eye"></i>
            View Church
        </a>
    </h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li><a href="{{ route('churches.index') }}">Churches</a></li>
        <li class="active">{{ $church->name }}</li>
    </ol>
@stop

@section('content')
    <div class="panel panel-default">
        <div class="panel-heading">Church Details</div>

        <div class="panel-body">

            {!! Form::model($church, ['files' => true, 'method' => 'PATCH', 'route' => ['churches.update', $church->id]]) !!}

            @include('directory::churches.fields.defaults', ['submitButtonText' => 'Update'])

            {!! Form::close() !!}
        </div>
    </div>

    <div class="panel panel-default">
        <div class="panel-heading">Address Details</div>

        <div class="panel-body">

            @if($church->address)
                {!! Form::model($church->address, ['method' => 'PUT', 'route' => ['churches.addresses.update', $church->id, $church->address->id]]) !!}
            @else
                {!! Form::open(['method' => 'POST', 'route' => ['churches.addresses.store', $church->id]]) !!}
            @endif

            @include('directory::addresses.fields.defaults')

            @if($church->address)
                {!! Form::button('Update', ['class' => 'btn btn-primary', 'type' => 'submit']) !!}
            @else
                {!! Form::button('Create', ['class' => 'btn btn-primary', 'type' => 'submit']) !!}
            @endif

            {!! Form::close() !!}

        </div>
    </div>
@endsection
