<div class="row">
    <div class="col-lg-7">
        <div class="form-group{{ $errors->has('name') ? ' has-error' : '' }}">
            {!! Form::label('name', 'Name', ['class' => 'control-label']) !!}
            {!! Form::text('name', null, ['class' => 'form-control']) !!}
            @if($errors->has('name'))
                <span class="text-danger">{{ $errors->first('name') }}</span>
            @endif
        </div>

        <div class="form-group{{ $errors->has('link') ? ' has-error' : '' }}">
            {!! Form::label('link', 'Website', ['class' => 'control-label']) !!}
            {!! Form::text('link', null, ['class' => 'form-control']) !!}
            @if($errors->has('link'))
                <span class="text-danger">{{ $errors->first('link') }}</span>
            @endif
        </div>

        <div class="form-group">
            {!! Form::label('circuit_id', 'Circuit') !!}
            {!! Form::select('circuit_id', $circuits, null, ['class' => 'form-control']) !!}
        </div>
    </div>
    <div class="col-lg-5">
        <div class="form-group">
            {!! Form::label('picture', 'Picture') !!}
            <div>
                <div class="fileinput{{ (isset($church) && $church->picture->originalFilename()) ? ' fileinput-exists' : ' fileinput-new' }}"
                     style="display: block;" data-provides="fileinput">
                    <div class="fileinput-preview fileinput-exists thumbnail" style="width: 100%; height: 300px;">
                        @if(isset($church))
                            <img src="{{ $church->picture->url('medium') }}" alt=""/>
                        @endif
                    </div>
                    <div>
                        <span class="btn btn-default btn-file">
                            <span class="fileinput-new">Select image</span>
                            <span class="fileinput-exists">Change</span>
                            {!! Form::file('picture') !!}
                        </span>
                        <a href="#" class="btn btn-default fileinput-exists" data-dismiss="fileinput">Remove</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

{!! Form::button($submitButtonText, ['class' => 'btn btn-primary', 'type' => 'submit']) !!}