@extends('app')

@section('title')
    <h2>
        {{ $circuit->name }}
        <a class="btn btn-default pull-right" href="{{ route('circuits.show', ['id' => $circuit->id]) }}">
            <i class="fa fa-eye"></i>
            View Circuit
        </a>
    </h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li><a href="{{ route('circuits.index') }}">Circuits</a></li>
        <li class="active">{{ $circuit->name }}</li>
    </ol>
@stop

@section('content')
    <div class="panel panel-default">
        <div class="panel-heading">Circuit Details</div>

        <div class="panel-body">

            {!! Form::model($circuit, ['method' => 'PATCH', 'route' => ['circuits.update', $circuit->id]]) !!}

            @include('directory::circuits.fields.defaults', ['submitButtonText' => 'Update'])

            {!! Form::close() !!}
        </div>
    </div>
@endsection
