<?php namespace DistrictHub\Directory;

use Illuminate\Database\Eloquent\Model;

class Circuit extends Model
{
    /**
     * Format the updated_at property.
     */
    use TimestampFormat;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'directory_circuits';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'number',
        'district_id',
    ];

    /**
     * The related District model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function district()
    {
        return $this->belongsTo(District::class);
    }

    /**
     * The related Church models.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function churches()
    {
        return $this->hasMany(Church::class);
    }

    /**
     * The related Member models.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function members()
    {
        return $this->hasMany(Member::class);
    }

    public function membersWithRoles()
    {
        return $this->hasManyThrough(Member::class, RoleMorphPivot::class);
    }

    /**
     * The related Role models
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function roles()
    {
        return $this->morphToMany(Role::class, 'scope', 'directory_member_role')
                    ->withPivot('member_id')->using(RoleMorphPivot::class)
                    ->withTimestamps()
                    ->orderBy('sort');
    }
}
