<?php namespace DistrictHub\Directory;

use Illuminate\Database\Eloquent\Model;

class District extends Model
{
    /**
     * Format the updated_at property.
     */
    use TimestampFormat;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'directory_districts';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'number',
    ];

    /**
     * The related Circuits models.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function circuits()
    {
        return $this->hasMany(Circuit::class);
    }

    /**
     * The related Churches models.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasManyThrough
     */
    public function churches()
    {
        return $this->hasManyThrough(Church::class, Circuit::class);
    }

    /**
     * The related Role models
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function roles()
    {
        return $this->morphToMany(Role::class, 'scope', 'directory_member_role')
                    ->withPivot('member_id')->using(RoleMorphPivot::class)
                    ->withTimestamps()
                    ->orderBy('sort');
    }
}
