<?php namespace DistrictHub\Directory\Events;

use DistrictHub\Directory\Church;
use DistrictHub\Directory\Member;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class ChurchLinkedToMember
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * @var Church
     */
    public $church;

    /**
     * @var Member
     */
    public $member;

    /**
     * Create a new event instance.
     *
     * @param Church $church
     * @param Member $member
     */
    public function __construct(Church $church, Member $member)
    {
        $this->church = $church;
        $this->member = $member;
    }
}
