<?php namespace DistrictHub\Directory\Gateways;

use Closure;
use Illuminate\Contracts\Cache\Repository as Cache;

/**
 * CachedGateway is an extension of Gateway that provides helper methods for caching.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 * @package      App\Gateways
 */
abstract class CachedGateway extends Gateway
{
    /**
     * @var int Cache duration in minutes.
     */
    protected $cacheMinutes = 60;

    /**
     * @var Cache
     */
    private $cache;

    /**
     * Create new gateway instance.
     *
     * @param Gateway $gateway
     * @param Cache   $cache
     *
     */
    public function __construct(Cache $cache)
    {
        $this->cache = $cache;
    }

    /**
     * Get cache repository with a tag of the current model.
     *
     * @return Cache
     */
    protected function cache()
    {
        return $this->cache->tags($this->model);
    }

    /**
     * Generate a cache based on a method name and arguments.
     *
     * @param string $method
     * @param array  $args
     *
     * @return string
     */
    protected function cacheKey($method, array $args = [])
    {
        if (empty($args)) {
            return md5($method);
        }

        return md5($method . serialize($args));
    }

    /**
     * Gets an object from the cache or generates it with the callback.
     *
     * @param string   $key
     * @param callable $callback
     *
     * @return mixed
     */
    protected function remember($key, Closure $callback)
    {
        return $this->cache()->remember($key, $this->cacheMinutes, $callback);
    }
}
