@extends('app')

@section('title')
    <h2>
        {{ $church->name }}
        @if(Auth::user()->ability('district-admin', 'edit-church'))
            <a class="btn btn-default pull-right" href="{{ route('churches.edit', ['id' => $church->id]) }}">
                <i class="fa fa-pencil"></i>
                Edit Church
            </a>
        @endif
    </h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li><a href="{{ route('churches.index') }}">Churches</a></li>
        <li class="active">{{ $church->name }}</li>
    </ol>
@stop

@section('content')
    <div class="row">
        <div class="col-lg-7">
            <h3>Church Details</h3>
            <dl class="dl-horizontal">
                <dt>Name</dt>
                <dd>{{ $church->name }}</dd>
                <dt>Website</dt>
                <dd>
                    @if($church->link)
                        <a href="{{ $church->link }}" target="_blank">{{ $church->link }}</a>
                        <span class="glyphicon glyphicon-new-window"></span>
                    @else
                        (None)
                    @endif
                </dd>
                <dt>Circuit</dt>
                <dd>{{ $church->circuit->name }}</dd>
                @if($church->ccli_number)
                    <dt>CCLI number</dt>
                    <dd>{{ $church->ccli_number }}</dd>
                @endif
                @if($church->membership_count)
                    <dt>Membership</dt>
                    <dd>{{ $church->membership_count }}</dd>
                @endif
            </dl>
            @if($church->address)
                <h3>Address Details</h3>
                <dl class="dl-horizontal">
                    <dt>Full address</dt>
                    <dd>{{ $church->address->full_address }}</dd>
                </dl>
            @endif
        </div>
        <div class="col-lg-5 text-right">
            <img src="{{ $church->picture->url('medium') }}" alt="{{ $church->name }}" class="img-thumbnail"/>
        </div>
    </div>

    @if($church->roles->count() > 0)
        <div class="row">
            <div class="col-lg-12">
                <h3>Church Roles</h3>
                <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
                    @foreach($church->roles->groupBy('name') as $name => $roles)
                        <div class="panel panel-roles">
                            <div class="panel-heading" role="tab" id="heading-{{ str_slug($name) }}">
                                <h4 class="panel-title">
                                    <a role="button" data-toggle="collapse" data-parent="#accordion"
                                       href="#collapse-{{ str_slug($name) }}" aria-expanded="false"
                                       aria-controls="collapse-{{ str_slug($name) }}">{{ $name }}</a>
                                    ({{ $roles->Count() }})
                                </h4>
                            </div>
                            <div id="collapse-{{ str_slug($name) }}" class="panel-collapse collapse" role="tabpanel"
                                 aria-labelledby="heading-{{ str_slug($name) }}">
                                <div class="panel-body">
                                    <div class="row">
                                        @foreach($roles->chunk(ceil($roles->count() / 4)) as $chunk)
                                            <div class="col-lg-3">
                                                <ul>
                                                    @foreach($chunk as $role)
                                                        <li>
                                                            <a href="{{ url('members', $role->pivot->member->id) }}">{{ $role->pivot->member->name }}</a>
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endif
@endsection
