<!doctype html>
<html>
    <head>
        <meta charset='utf-8'>
        <title>Circuit Directory</title>
        <link type="text/css" rel="stylesheet" href="{{ url(mix('css/print.css')) }}">
    </head>
    <body>
        <script type="text/php">
            $font = $fontMetrics->get_font('Helvetica, Arial, sans-serif', 'normal');
            $GLOBALS['chapters'] = array();
            $GLOBALS['backside'] = $pdf->open_object();
        </script>
        <div class="page page--preface">
            <h1 class="title">
                {{ $circuit->name }} Methodist Circuit {{ $circuit->district->number }}/{{ $circuit->number }}
                <small>Circuit Directory {{ date('Y') }}/{{ Carbon\Carbon::create()->addYear(1)->format('y') }}</small>
            </h1>
            <p class="sub-title">
                Registered Charity No. {{ $circuit->charity_number }}
                <br>
                Website: {{ $circuit->website }}
            </p>
            <h2 class="heading">Welcome</h2>
            <p>
                Welcome to the Circuit Directory for Birmingham Methodist Circuit. This document includes the
                information and contact details for everyone who holds a role within the thirty seven churches
                which make up our circuit, as well as the different Circuit Roles to which people from our
                churches are appointed by our Circuit Assembly. This includes Circuit Leadership, Circuit
                Forums, as well as Local Preachers. In addition to this it also contains the details of the Ministers
                Stationed in our Circuit and the Lay Staff we employ across it, as well as contacts for both our
                District, the Queens Foundation and the Methodist Church.
            </p>
            <h2 class="heading">Data Protection</h2>
            <p>
                <strong>Protecting Data:</strong>
                We take the protection data in this directory very seriously. Please do not leave
                copies of this directory available to those not permitted to use it. For more details please turn to the
                inside back cover for full details about the Circuit Directory and Data Protection.
            </p>
            <h2 class="heading">Index</h2>
            <table class="table">
                <thead>
                    <tr>
                        <th>Information</th>
                        <th width="20%">Page no.</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>Quick Circuit Contacts</td>
                        <td>%%CH1%%</td>
                    </tr>
                    <tr>
                        <td>Circuit Officers</td>
                        <td>%%CH2%%</td>
                    </tr>
                    <tr>
                        <td>Forums</td>
                        <td>%%CH3%%</td>
                    </tr>
                    <tr>
                        <td>Ministers</td>
                        <td>%%CH4%%</td>
                    </tr>
                    <tr>
                        <td>Circuit Staff</td>
                        <td>%%CH5%%</td>
                    </tr>
                    <tr>
                        <td>Lay Chaplains</td>
                        <td>%%CH6%%</td>
                    </tr>
                    <tr>
                        <td>Local Preachers</td>
                        <td>%%CH7%%</td>
                    </tr>
                    <tr>
                        <td>Churches</td>
                        <td>%%CH8%%</td>
                    </tr>
                    <tr>
                        <td>Index of Names, Addresses, etc</td>
                        <td>%%CH9%%</td>
                    </tr>
                </tbody>
            </table>
            <div class="footer"></div>
            <script type="text/php">$pdf->close_object();</script>
        </div>
        <div class="page">
            <script type="text/php">$GLOBALS['chapters']['1'] = $pdf->get_page_number();</script>
            <h2 class="heading">Quick Circuit Contacts</h2>
            <p>
                Below are a list of key important or emergency contacts for our Circuit. The full details of individuals
                can be found in the A-Z index at the back of the directory.
            </p>
            <h3 class="sub-heading">Circuit Superintendents</h3>
            <table class="table">
                <thead>
                    <tr>
                        <th width="30%">Name</th>
                        <th>Email</th>
                        <th width="20%">Phone</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($superintendents as $member)
                        <tr>
                            <td>{{ $member->name }}</td>
                            <td>
                                @if($member->primary_email)
                                    {{ $member->primary_email->address }}
                                @endif
                            </td>
                            <td>
                                @foreach($member->phones as $phone)
                                    @if($loop->count > 1)
                                        {{ substr($phone->type->description, 0, 1) }}:
                                    @endif
                                    {{ $phone->number }}<br>
                                @endforeach
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <h3 class="sub-heading">Church Contacts</h3>
            <p>
                For any matter relating to your church or to get in touch with another church, please see the
                churches section of this directory which will give details of who to contact.
            </p>
            <h3 class="sub-heading">Safeguarding</h3>
            <p>
                If you need to discuss a safeguarding matter relating to your church please contact your church
                safeguarding officer. If you cannot reach them please either contact our District Safeguarding
                Officer in an urgent situation (details below) or in a less urgent situation, please contact our circuit
                safeguarding team (details on page 3).
            </p>
            <table class="table">
                <thead>
                    <tr>
                        <th width="30%">Name</th>
                        <th>Email</th>
                        <th width="20%">Phone</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($safeguarding as $member)
                        <tr>
                            <td>{{ $member->name }}</td>
                            <td>
                                @if($member->primary_email)
                                    {{ $member->primary_email->address }}
                                @endif
                            </td>
                            <td>
                                @foreach($member->phones as $phone)
                                    @if($loop->count > 1)
                                        {{ substr($phone->type->description, 0, 1) }}:
                                    @endif
                                    {{ $phone->number }}<br>
                                @endforeach
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <h3 class="sub-heading">Other Useful Contacts</h3>
            <p>
                For the full contact details of our Circuit Office Team and our Lay Workers, please visit page x. A
                few short cut details are below.
            </p>
            <ul>
                <li>
                    For information about the <strong>plan</strong>, <strong>property</strong>,
                    <strong>personnel</strong>, or <strong>statistics</strong>, please contact Sue Saunderson on
                    0121 472 1060 or ssaunderson@birminghammethodistcircuit.org.uk
                </li>
                <li>
                    For information about our Circuit Assembly please contact Beverley Francis on 0121 616
                    1800 or bfrancis@birminghammethodistcircuit.org.uk
                </li>
                <li>
                    For information about our website, weekly email, social media, or any other communications
                    related matter. Please contact Beverley Francis or Tom Milton on 0121 616 1800, or be
                    emailing news@birminghammethodistcircuit.org.uk
                </li>
                <li>
                    Finally, for information regarding training please contact Tom Milton on 0121 616 1800 or
                    07875 379 469, or emailing on tmilton@birminghammethodistcircuit.org.uk
                </li>
            </ul>
            <p class="note">
                Not sure who to contact? For general enquiries please contact our Central Office on 0121 616 1800
                or contact@birminghammethodistcircuit.org.uk
            </p>
            <div class="footer"></div>
        </div>
        <div class="page">
            <script type="text/php">$GLOBALS['chapters']['2'] = $pdf->get_page_number();</script>
            <h2 class="heading">{{ $circuit_officers->name }}</h2>
            @foreach($circuit_officers->roles as $role)
                @if($role->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                    <table class="table">
                        <thead>
                            <tr>
                                <th colspan="3">{{ $role->name }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($role->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                <tr>
                                    <td width="30%">{{ $member->name }}</td>
                                    <td>
                                        @if($member->primary_email)
                                            {{ $member->primary_email->address }}
                                        @endif
                                    </td>
                                    <td width="20%">
                                        @foreach($member->phones as $phone)
                                            @if($loop->count > 1)
                                                {{ substr($phone->type->description, 0, 1) }}:
                                            @endif
                                            {{ $phone->number }}<br>
                                        @endforeach
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            @endforeach
            @foreach($circuit_officers->roleGroups as $group)
                @if($group->roles->count() > 0)
                    <h3 class="sub-heading">{{ $group->name }}</h3>
                    @foreach($group->roles as $groupRole)
                        @if($groupRole->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th colspan="3">{{ $groupRole->name }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($groupRole->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                        <tr>
                                            <td width="30%">{{ $member->name }}</td>
                                            <td>
                                                @if($member->primary_email)
                                                    {{ $member->primary_email->address }}
                                                @endif
                                            </td>
                                            <td width="20%">
                                                @foreach($member->phones as $phone)
                                                    @if($loop->count > 1)
                                                        {{ substr($phone->type->description, 0, 1) }}:
                                                    @endif
                                                    {{ $phone->number }}<br>
                                                @endforeach
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @endif
                    @endforeach
                @endif
            @endforeach
            <div class="footer"></div>
        </div>
        <div class="page">
            <script type="text/php">$GLOBALS['chapters']['3'] = $pdf->get_page_number();</script>
            <h2 class="heading">{{ $forum_contacts->name }}</h2>
            @foreach($forum_contacts->roles as $role)
                @if($role->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                    <table class="table">
                        <thead>
                            <tr>
                                <th colspan="3">{{ $role->name }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($role->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                <tr>
                                    <td width="30%">{{ $member->name }}</td>
                                    <td>
                                        @if($member->primary_email)
                                            {{ $member->primary_email->address }}
                                        @endif
                                    </td>
                                    <td width="20%">
                                        @foreach($member->phones as $phone)
                                            @if($loop->count > 1)
                                                {{ substr($phone->type->description, 0, 1) }}:
                                            @endif
                                            {{ $phone->number }}<br>
                                        @endforeach
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            @endforeach
            @foreach($forum_contacts->roleGroups as $group)
                @if($group->roles->count() > 0)
                    <h3 class="sub-heading">{{ $group->name }}</h3>
                    @foreach($group->roles as $groupRole)
                        @if($groupRole->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th colspan="3">{{ $groupRole->name }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($groupRole->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                        <tr>
                                            <td width="30%">{{ $member->name }}</td>
                                            <td>
                                                @if($member->primary_email)
                                                    {{ $member->primary_email->address }}
                                                @endif
                                            </td>
                                            <td width="20%">
                                                @foreach($member->phones as $phone)
                                                    @if($loop->count > 1)
                                                        {{ substr($phone->type->description, 0, 1) }}:
                                                    @endif
                                                    {{ $phone->number }}<br>
                                                @endforeach
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @endif
                    @endforeach
                @endif
            @endforeach
            <div class="footer"></div>
        </div>
        <div class="page">
            <script type="text/php">$GLOBALS['chapters']['4'] = $pdf->get_page_number();</script>
            <h2 class="heading">{{ $ministers->name }}</h2>
            @foreach($ministers->roles as $role)
                @if($role->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                    <table class="table">
                        <thead>
                            <tr>
                                <th colspan="3">{{ $role->name }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($role->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                <tr>
                                    <td width="30%">{{ $member->name }}</td>
                                    <td>
                                        @if($member->primary_email)
                                            {{ $member->primary_email->address }}<br>
                                        @endif
                                        @if($member->primary_address)
                                            {{ $member->primary_address->full_address }}
                                        @endif
                                    </td>
                                    <td width="20%">
                                        @foreach($member->phones as $phone)
                                            @if($loop->count > 1)
                                                {{ substr($phone->type->description, 0, 1) }}:
                                            @endif
                                            {{ $phone->number }}<br>
                                        @endforeach
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            @endforeach
            @foreach($ministers->roleGroups as $group)
                @if($group->roles->count() > 0)
                    <h3 class="sub-heading">{{ $group->name }}</h3>
                    @foreach($group->roles as $groupRole)
                        @if($groupRole->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th colspan="3">{{ $groupRole->name }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($groupRole->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                        <tr>
                                            <td width="30%">{{ $member->name }}</td>
                                            <td>
                                                @if($member->primary_email)
                                                    {{ $member->primary_email->address }}<br>
                                                @endif
                                                @if($member->primary_address)
                                                    {{ $member->primary_address->full_address }}
                                                @endif
                                            </td>
                                            <td width="20%">
                                                @foreach($member->phones as $phone)
                                                    @if($loop->count > 1)
                                                        {{ substr($phone->type->description, 0, 1) }}:
                                                    @endif
                                                    {{ $phone->number }}<br>
                                                @endforeach
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @endif
                    @endforeach
                @endif
            @endforeach
            <div class="footer"></div>
        </div>
        <div class="page">
            <script type="text/php">$GLOBALS['chapters']['5'] = $pdf->get_page_number();</script>
            <h2 class="heading">{{ $circuit_staff->name }}</h2>
            @foreach($circuit_staff->roles as $role)
                @if($role->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                    <table class="table">
                        <tbody>
                            @foreach($role->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                <tr>
                                    <td width="30%">{{ $member->name }}</td>
                                    <td>
                                        @if($member->primary_email)
                                            {{ $member->primary_email->address }}
                                        @endif
                                    </td>
                                    <td width="20%">
                                        @foreach($member->phones as $phone)
                                            @if($loop->count > 1)
                                                {{ substr($phone->type->description, 0, 1) }}:
                                            @endif
                                            {{ $phone->number }}<br>
                                        @endforeach
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-italic">{{ $role->name }}</td>
                                    <td colspan="2">{{ $member->pivot->description }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            @endforeach
            @foreach($circuit_staff->roleGroups as $group)
                @if($group->roles->count() > 0)
                    <h3 class="sub-heading">{{ $group->name }}</h3>
                    @foreach($group->roles as $groupRole)
                        @if($groupRole->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                            <table class="table">
                                <tbody>
                                    @foreach($groupRole->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                        <tr class="flush-bottom">
                                            <td width="30%">{{ $member->name }}</td>
                                            <td>
                                                @if($member->primary_email)
                                                    {{ $member->primary_email->address }}
                                                @endif
                                            </td>
                                            <td width="20%">
                                                @foreach($member->phones as $phone)
                                                    @if($loop->count > 1)
                                                        {{ substr($phone->type->description, 0, 1) }}:
                                                    @endif
                                                    {{ $phone->number }}<br>
                                                @endforeach
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="text-italic">{{ $groupRole->name }}</td>
                                            <td colspan="2">{{ $member->pivot->description }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @endif
                    @endforeach
                @endif
            @endforeach
            <div class="footer"></div>
        </div>
        <div class="page">
            <script type="text/php">$GLOBALS['chapters']['6'] = $pdf->get_page_number();</script>
            <h2 class="heading">{{ $lay_chaplains->name }}</h2>
            @foreach($lay_chaplains->roles as $role)
                @if($role->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                    <table class="table">
                        <thead>
                            <tr>
                                <th colspan="3">{{ $role->name }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($role->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                <tr>
                                    <td width="30%">{{ $member->name }}</td>
                                    <td>
                                        @if($member->primary_email)
                                            {{ $member->primary_email->address }}
                                        @endif
                                    </td>
                                    <td width="20%">
                                        @foreach($member->phones as $phone)
                                            @if($loop->count > 1)
                                                {{ substr($phone->type->description, 0, 1) }}:
                                            @endif
                                            {{ $phone->number }}<br>
                                        @endforeach
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            @endforeach
            @foreach($lay_chaplains->roleGroups as $group)
                @if($group->roles->count() > 0)
                    <h3 class="sub-heading">{{ $group->name }}</h3>
                    @foreach($group->roles as $groupRole)
                        @if($groupRole->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th colspan="3">{{ $groupRole->name }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($groupRole->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                        <tr>
                                            <td width="30%">{{ $member->name }}</td>
                                            <td>
                                                @if($member->primary_email)
                                                    {{ $member->primary_email->address }}
                                                @endif
                                            </td>
                                            <td width="20%">
                                                @foreach($member->phones as $phone)
                                                    @if($loop->count > 1)
                                                        {{ substr($phone->type->description, 0, 1) }}:
                                                    @endif
                                                    {{ $phone->number }}<br>
                                                @endforeach
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @endif
                    @endforeach
                @endif
            @endforeach
            <div class="footer"></div>
        </div>
        <div class="page">
            <script type="text/php">$GLOBALS['chapters']['7'] = $pdf->get_page_number();</script>
            <h2 class="heading">{{ $local_preachers->name }}</h2>
            @foreach($local_preachers->roles as $role)
                @if($role->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                    <h3 class="sub-heading">{{ $role->name }}</h3>
                    <table class="table">
                        <tbody>
                            @foreach($role->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                <tr class="flush-bottom">
                                    <td width="30%">{{ $member->name }}</td>
                                    <td>
                                        @if($member->primary_email)
                                            {{ $member->primary_email->address }}<br>
                                        @endif
                                        @if($member->primary_address)
                                            {{ $member->primary_address->full_address }}
                                        @endif
                                    </td>
                                    <td width="20%">
                                        @foreach($member->phones as $phone)
                                            @if($loop->count > 1)
                                                {{ substr($phone->type->description, 0, 1) }}:
                                            @endif
                                            {{ $phone->number }}<br>
                                        @endforeach
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="3">{{ $member->pivot->description }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            @endforeach
            @foreach($local_preachers->roleGroups as $group)
                @if($group->roles->count() > 0)
                    <h3 class="sub-heading">{{ $group->name }}</h3>
                    @foreach($group->roles as $groupRole)
                        @if($groupRole->members()->wherePivot('scope_id', $circuit->id)->count() > 0)
                            <table class="table">
                                <tbody>
                                    @foreach($groupRole->members()->wherePivot('scope_id', $circuit->id)->orderBy('last_name')->get() as $member)
                                        <tr class="flush-bottom">
                                            <td width="30%">{{ $member->name }}</td>
                                            <td>
                                                @if($member->primary_email)
                                                    {{ $member->primary_email->address }}<br>
                                                @endif
                                                @if($member->primary_address)
                                                    {{ $member->primary_address->full_address }}
                                                @endif
                                            </td>
                                            <td width="20%">
                                                @foreach($member->phones as $phone)
                                                    @if($loop->count > 1)
                                                        {{ substr($phone->type->description, 0, 1) }}:
                                                    @endif
                                                    {{ $phone->number }}<br>
                                                @endforeach
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="text-italic">{{ $groupRole->name }}</td>
                                            <td colspan="2">{{ $member->pivot->description }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        @endif
                    @endforeach
                @endif
            @endforeach
            <div class="footer"></div>
        </div>
        <div class="page">
            <script type="text/php">$GLOBALS['chapters']['8'] = $pdf->get_page_number();</script>
            <h2 class="heading">Churches</h2>
            @foreach($circuit->churches as $church)
                <h3 class="sub-heading">{{ $church->name }}</h3>
                <table class="table">
                    <tbody>
                        <tr>
                            <td colspan="2">
                                @if($church->address)
                                    {{ $church->address->full_address }}<br>
                                @endif
                                @if($church->phone)
                                    {{ $church->phone->number }}
                                @endif
                            </td>
                            <td width="20%">
                                @if($church->membership_count)
                                    Members: {{ $church->membership_count }}<br>
                                @endif
                                @if($church->ccli_number)
                                    CCLI: {{ $church->ccli_number }}
                                @endif
                            </td>
                        </tr>
                        <?php $prevRole = $role->name; ?>
                        @foreach($church->roles->groupBy('name') as $name => $roles)
                            @if($roles->count() > 1)
                                <tr class="flush-bottom">
                            @else
                                <tr>
                            @endif
                                <td rowspan="{{ $roles->count() }}" width="30%">{{ $name }}</td>
                                <td>{{ $roles->first()->pivot->member->name }}</td>
                                <td width="20%">
                                    @foreach($roles->first()->pivot->member->phones as $phone)
                                        @if($loop->count > 1)
                                            {{ substr($phone->type->description, 0, 1) }}:
                                        @endif
                                        {{ $phone->number }}<br>
                                    @endforeach
                                </td>
                            </tr>
                            @foreach($roles->take(-($roles->count() - 1)) as $role)
                                @if($loop->last)
                                    <tr>
                                @else
                                    <tr class="flush-bottom">
                                @endif
                                    <td>{{ $role->pivot->member->name }}</td>
                                    <td width="20%">
                                        @foreach($role->pivot->member->phones as $phone)
                                            @if($loop->count > 1)
                                                {{ substr($phone->type->description, 0, 1) }}:
                                            @endif
                                            {{ $phone->number }}<br>
                                        @endforeach
                                    </td>
                                </tr>
                            @endforeach
                        @endforeach
                    </tbody>
                </table>
            @endforeach
            <div class="footer"></div>
        </div>
        <div class="page">
            <script type="text/php">$GLOBALS['chapters']['9'] = $pdf->get_page_number();</script>
            <h2 class="heading">Index of Names, Address, Email, Telephone Numbers</h2>
            <table class="table">
                <thead>
                    <tr>
                        <th width="30%">Name</th>
                        <th>Email</th>
                        <th width="20%">Phone</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($circuit->membersWithRoles as $member)
                        <tr>
                            <td>{{ $member->name }}</td>
                            <td>
                                @if($member->primary_email)
                                    {{ $member->primary_email->address }}<br>
                                @endif
                                @if($member->primary_address)
                                    {{ $member->primary_address->full_address }}
                                @endif
                            </td>
                            <td>
                                @foreach($member->phones as $phone)
                                    @if($loop->count > 1)
                                        {{ substr($phone->type->description, 0, 1) }}:
                                    @endif
                                    {{ $phone->number }}<br>
                                @endforeach
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="footer"></div>
        </div>
        <script type="text/php">
            foreach ($GLOBALS['chapters'] as $chapter => $page) {
                $pdf->get_cpdf()->objects[$GLOBALS['backside']]['c'] = str_replace( '%%CH'.$chapter.'%%' , $page , $pdf->get_cpdf()->objects[$GLOBALS['backside']]['c'] );
            }
            $pdf->page_script('
                if ($PAGE_NUM==1 ) {
                    $pdf->add_object($GLOBALS["backside"],"add");
                    $pdf->stop_object($GLOBALS["backside"]);
                }
            ');
        </script>
        <script type="text/php">
            if (isset($pdf)) {
                $pdf->page_script('
                    $font = $fontMetrics->get_font(\'Helvetica, Arial, sans-serif\', \'normal\');
                    $pageText = $PAGE_NUM;
                    $y = 760;
                    $x = 300;
                    $size = 12;
                    $pdf->text($x, $y, $pageText, $font, $size);
                ');
            }
        </script>
    </body>
</html>
