@extends('app')

@section('title')
    <h2>
        {{ $member->name }}
        @if(Auth::user()->ability('district-admin', 'edit-member'))
            <a class="btn btn-default pull-right" href="{{ route('members.edit', ['id' => $member->id]) }}">
                <i class="fa fa-pencil"></i>
                Edit Member
            </a>
        @endif
    </h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li><a href="{{ route('members.index') }}">Members</a></li>
        <li class="active">{{ $member->name }}</li>
    </ol>
@stop

@section('content')
    <div class="row">
        <div class="col-lg-6">
            <h3>Personal Details</h3>
            <dl class="dl-horizontal">
                <dt>Title</dt>
                <dd>{{ $member->title }}</dd>
                <dt>First name</dt>
                <dd>{{ $member->first_name }}</dd>
                <dt>Last name</dt>
                <dd>{{ $member->last_name }}</dd>
                <dt>Type</dt>
                <dd>{{ $member->type->description }}</dd>
                <dt>Circuit</dt>
                <dd>{{ $member->circuit->name }}</dd>
            </dl>
        </div>
        <div class="col-lg-6">
            @if($member->primary_address || $member->primary_phone || $member->primary_email)
                <h3>Contact Details</h3>
                <dl class="dl-horizontal">
                    @if($member->primary_address)
                        <dt>Primary address</dt>
                        <dd>{{ $member->primary_address->full_address }}</dd>
                    @endif
                    @if($member->primary_phone)
                        <dt>Primary phone number</dt>
                        <dd>{{ $member->primary_phone->number }}</dd>
                    @endif
                    @if($member->primary_email)
                        <dt>Primary email address</dt>
                        <dd>{{ $member->primary_email->address }}</dd>
                    @endif
                </dl>
            @endif
        </div>
    </div>
    <div class="row">
        @if($member->church_roles->count() > 0)
            <div class="col-lg-6">
                <h3>Church Roles</h3>
                <ul>
                    @foreach($member->church_roles as $role)
                        <li>{{ $role->name }} (<a
                                    href="{{ url('churches', $role->pivot->scope_id) }}">{{ $role->pivot->scope->name }}</a>)
                        </li>
                    @endforeach
                </ul>
            </div>
        @endif
        @if($member->circuit_roles->count() > 0)
            <div class="col-lg-6">
                <h3>Circuit Roles</h3>
                <ul>
                    @foreach($member->circuit_roles as $role)
                        <li>{{ $role->name }} (<a
                                    href="{{ url('circuits', $role->pivot->scope_id) }}">{{ $role->pivot->scope->name }}</a>)
                        </li>
                    @endforeach
                </ul>
            </div>
        @endif
        @if($member->district_roles->count() > 0)
            <div class="col-lg-6">
                <h3>District Roles</h3>
                <ul>
                    @foreach($member->district_roles as $role)
                        <li>{{ $role->name }} (<a
                                    href="{{ url('districts', $role->pivot->scope_id) }}">{{ $role->pivot->scope->name }}</a>)
                        </li>
                    @endforeach
                </ul>
            </div>
        @endif
    </div>
    @if($member->groups->count() > 0)
        <div class="row">
            <div class="col-lg-12">
                <h3>Groups</h3>
                <ul>
                    @foreach($member->groups as $group)
                        <li>
                            <a href="{{ route('groups.show', $group->id) }}">{{ $group->name }}</a>
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>
    @endif
    @if(Auth::user()->ability('district-admin', 'edit-member') && !empty($member->comments))
        <div class="alert alert-warning">
            {{ $member->comments }}
        </div>
    @endif
@endsection
