<?php namespace DistrictHub\Directory\Http\Composers;

use DistrictHub\Contracts\Gateways\Directory\CircuitGateway;
use Illuminate\Contracts\View\View;

class ChurchComposer
{
    /**
     * @var CircuitGateway
     */
    private $circuits;

    /**
     * Create a new member composer.
     *
     * @param CircuitGateway $circuits
     */
    public function __construct(CircuitGateway $circuits)
    {
        $this->circuits = $circuits;
    }

    /**
     * Bind data to the view.
     *
     * @param  View $view
     *
     * @return void
     */
    public function compose(View $view)
    {
        $view->with('circuits', $this->circuits->options('name', 'id'));
    }
}
