<?php namespace DistrictHub\Directory\Jobs;

use DistrictHub\Directory\Church;
use DistrictHub\Directory\Events\ChurchWasCreated;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class CreateChurch implements ShouldQueue
{
    use InteractsWithQueue, Queueable, SerializesModels;

    protected $attributes;

    /**
     * Create a new command instance.
     *
     * @param int   $id
     * @param array $attributes
     *
     * @return void
     */
    public function __construct(array $attributes)
    {
        $this->attributes = $attributes;
    }

    /**
     * Execute the command.
     *
     * @return void
     */
    public function handle()
    {
        $church = Church::create($this->attributes);

        event(new ChurchWasCreated($church));
    }
}
