<?php namespace DistrictHub\Directory\Jobs;

use DistrictHub\Contracts\Gateways\Directory\CircuitGateway;
use DistrictHub\Directory\Events\CircuitWasUpdated;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class UpdateCircuit implements ShouldQueue
{
    use InteractsWithQueue, Queueable, SerializesModels;

    protected $id;

    protected $attributes;

    /**
     * Create a new command instance.
     *
     * @param int   $id
     * @param array $attributes
     *
     * @return void
     */
    public function __construct($id, array $attributes)
    {
        $this->id = $id;
        $this->attributes = $attributes;
    }

    /**
     * Execute the command.
     *
     * @return void
     */
    public function handle(CircuitGateway $circuitGateway)
    {
        if ($circuitGateway->update($this->id, $this->attributes)) {
            $circuit = $circuitGateway->find($this->id);
            event(new CircuitWasUpdated($circuit));
        }
    }
}
