@extends('app')

@section('title')
    <h2>
        Directory
        @if(Auth::user()->ability('district-admin', 'create-circuit'))
            <a class="btn btn-default pull-right" href="{{ route('circuits.role-groups.create', $circuit->id) }}">
                <i class="fa fa-plus-circle"></i>
                Add Template
            </a>
        @endif
    </h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li><a href="{{ route('circuits.index') }}">Circuits</a></li>
        <li><a href="{{ route('circuits.show', $circuit->id) }}">{{ $circuit->name }}</a></li>
        <li class="active">Directory</li>
    </ol>
@stop

@section('content')
    <div class="panel panel-default">
        <div class="panel-heading">Templates</div>


    </div>
@endsection

@section('scripts')
    <script type="text/javascript" src="{{ mix('js/app.js') }}"></script>
@stop
