<?php namespace DistrictHub\Directory\Http\Composers;

use DistrictHub\Contracts\Gateways\Directory\CircuitGateway;
use DistrictHub\Contracts\Gateways\Directory\MemberTitleGateway;
use DistrictHub\Contracts\Gateways\Directory\MemberTypeGateway;
use DistrictHub\Directory\Role;
use Illuminate\Contracts\View\View;

class MemberComposer
{
    protected $circuits;

    protected $titles;

    protected $types;

    /**
     * Create a new member composer.
     *
     * @return void
     */
    public function __construct(CircuitGateway $circuits, MemberTitleGateway $titles, MemberTypeGateway $types)
    {
        $this->circuits = $circuits;
        $this->titles = $titles;
        $this->types = $types;
    }

    /**
     * Bind data to the view.
     *
     * @param  View $view
     *
     * @return void
     */
    public function compose(View $view)
    {
        $view->with('circuits', $this->circuits->options('name', 'id'));
        $view->with('titles', $this->titles->options('description', 'description', '(None)'));
        $view->with('types', $this->types->options('description'));
        $roles = Role::orderBy('scope', 'desc')->orderBy('sort')->get()->pluck('name', 'id')->toArray();
        $view->with('roles', [null => '--Select--'] + $roles);
    }
}
