@extends('app')

@section('title')
    <h2>
        {{ $district->name }}
        @if(Auth::user()->ability('district-admin', 'edit-district'))
            <a class="btn btn-default pull-right" href="{{ route('districts.edit', ['id' => $district->id]) }}">
                <i class="fa fa-pencil"></i>
                Edit District
            </a>
        @endif
    </h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li>Districts</li>
        <li class="active">{{ $district->name }}</li>
    </ol>
@stop

@section('content')
    <div class="row">
        <div class="col-lg-6">
            <h3>District Details</h3>
            <dl class="dl-horizontal">
                <dt>Name</dt>
                <dd>{{ $district->number }} {{ $district->name }}</dd>
                @if($district->charity_number)
                    <dt>Charity number</dt>
                    <dd>{{ $district->charity_number }}</dd>
                @endif
                @if($district->website)
                    <dt>Website</dt>
                    <dd>
                        <a href="{{ $district->website }}" target="_blank">{{ $district->website }}</a>
                        <span class="glyphicon glyphicon-new-window"></span>
                    </dd>
                @endif
            </dl>
        </div>
        @if($district->roles->count() > 0)
            <div class="col-lg-12">
                <h3>District Roles</h3>
                <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
                    @foreach($district->roles->groupBy('name') as $name => $roles)
                        <div class="panel panel-roles">
                            <div class="panel-heading" role="tab" id="heading-{{ str_slug($name) }}">
                                <h4 class="panel-title">
                                    <a role="button" data-toggle="collapse" data-parent="#accordion"
                                       href="#collapse-{{ str_slug($name) }}" aria-expanded="false"
                                       aria-controls="collapse-{{ str_slug($name) }}">{{ $name }}</a>
                                    ({{ $roles->Count() }})
                                </h4>
                            </div>
                            <div id="collapse-{{ str_slug($name) }}" class="panel-collapse collapse" role="tabpanel"
                                 aria-labelledby="heading-{{ str_slug($name) }}">
                                <div class="panel-body">
                                    <div class="row">
                                        @foreach($roles->chunk(ceil($roles->count() / 4)) as $chunk)
                                            <div class="col-lg-3">
                                                <ul>
                                                    @foreach($chunk as $role)
                                                        <li>
                                                            <a href="{{ url('members', $role->pivot->member->id) }}">{{ $role->pivot->member->name }}</a>
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif
        {{--<div class="col-lg-12">--}}
        {{--<h3>List of Circuits</h3>--}}
        {{--<div class="row">--}}
        {{--@foreach($district->churches as $church)--}}
        {{--<div class="col-sm-6 col-md-4 col-lg-3">--}}
        {{--<div class="panel panel-primary">--}}
        {{--<div class="panel-body">--}}
        {{--<img class="img-rounded" width="100%" src="{{ $church->picture->url('medium') }}" alt="{{ $church->name }}">--}}
        {{--</div>--}}

        {{--<div class="panel-footer">--}}
        {{--<h4>{{ $church->name }}</h4>--}}
        {{--<p>--}}
        {{--<a href="{{ route('churches.show', $church->id) }}" class="btn btn-primary" role="button">--}}
        {{--<i class="fa fa-eye"></i>--}}
        {{--View--}}
        {{--</a>--}}
        {{--@if(Auth::user()->ability('district-admin', 'edit-church'))--}}
        {{--<a href="{{ route('churches.edit', $church->id) }}" class="btn btn-default" role="button">--}}
        {{--<i class="fa fa-pencil"></i>--}}
        {{--Edit--}}
        {{--</a>--}}
        {{--@endif--}}
        {{--</p>--}}
        {{--</div>--}}
        {{--</div>--}}
        {{--</div>--}}
        {{--@endforeach--}}
        {{--</div>--}}
        {{--</div>--}}
    </div>
@endsection
