<?php namespace DistrictHub\Directory\Gateways;

use DistrictHub\Contracts\Gateways\Directory\RoleGateway as RoleGatewayContract;
use DistrictHub\Directory\Gateways\Gateway;
use DistrictHub\Directory\Role;

/**
 * RoleGateway.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 * @package      App\Gateways\Directory
 */
class RoleGateway extends Gateway implements RoleGatewayContract
{
    /**
     * @var string FQCN of model.
     */
    protected $model = Role::class;

    /**
     * Search records with fields and sort with order.
     *
     * @param array $fields
     * @param array $order
     *
     * @return \Illuminate\Database\Eloquent\Collection|static[]
     */
    public function search(array $fields, array $order)
    {
        // Start query
        $roles = $this->model();

        // Searching
        foreach ($fields as $field => $value) {
            if (!empty($value)) {
                if ($field === 'name') {
                    $roles = $roles->where($field, 'like', "%{$value}%");
                } else {
                    $roles = $roles->where($field, '=', "$value");
                }
            }
        }

        // Ordering
        if (!empty($order)) {
            foreach ($order as $orderBy) {
                $roles = $roles->orderBy($orderBy['column'], $orderBy['dir']);
            }
        } else {
            $roles = $roles
                ->orderBy('scope', 'desc')
                ->orderBy('name', 'asc');
        }

        // Get query results
        return $roles->get();
    }

    /**
     * Get the total number of records.
     *
     * @return int
     */
    public function total()
    {
        return $this->model()->count();
    }

    /**
     * Find a model by its primary key.
     *
     * @param  mixed $id
     *
     * @return \DistrictHub\Directory\Member|null
     */
    public function find($id)
    {
        return $this->model()->find($id);
    }

    /**
     * Update a model with the specified primary key.
     *
     * @param int   $id
     * @param array $attributes
     *
     * @return bool
     */
    public function update($id, array $attributes)
    {
        $model = $this->model()->find($id)->fill($attributes);

        if ($model->save()) {
            return true;
        }

        return false;
    }
}
