@extends('app')

@section('title')
    <h2>
        {{ $district->name }}
        <a class="btn btn-default pull-right" href="{{ route('districts.show', ['id' => $district->id]) }}">
            <i class="fa fa-eye"></i>
            View District
        </a>
    </h2>
@stop

@section('breadcrumbs')
    <ol class="breadcrumb breadcrumb-plain flush-bottom">
        <li><a href="/"><i class="fa fa-home visible-xs"></i> <span class="hidden-xs">Dashboard</span></a></li>
        <li>Districts</li>
        <li class="active">{{ $district->name }}</li>
    </ol>
@stop

@section('content')
    <div class="panel panel-default">
        <div class="panel-heading">District Details</div>

        <div class="panel-body">

            {!! Form::model($district, ['method' => 'PATCH', 'route' => ['districts.update', $district->id]]) !!}

            @include('directory::districts.fields.defaults', ['submitButtonText' => 'Update'])

            {!! Form::close() !!}
        </div>
    </div>
@endsection
