<?php namespace DistrictHub\Directory;

use Illuminate\Database\Eloquent\Model;

class EmailType extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'directory_email_types';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'description',
    ];

    /**
     * The related Email models.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function emails()
    {
        return $this->hasMany(Email::class);
    }
}
