<?php namespace DistrictHub\Directory\Gateways;

/**
 * Gateway is the base class for all table gateways.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 * @package      App\Gateways
 */
abstract class Gateway
{
    /**
     * @var string FQCN of model.
     */
    protected $model;

    /**
     * Generate new model instance.
     *
     * @return \Illuminate\Database\Eloquent\Model
     */
    protected function model()
    {
        $class = $this->model;

        return new $class();
    }
}
