<?php namespace DistrictHub\Directory\Listeners;

use DistrictHub\Directory\Events\ChurchUnlinkedFromMember;
use DistrictHub\Support\Listeners\Notification;

class AlertChurchUnlinkedFromMember extends Notification
{
    /**
     * Handle the event.
     *
     * @param  ChurchUnlinkedFromMember $event
     *
     * @return void
     */
    public function handle(ChurchUnlinkedFromMember $event)
    {
        $this->notifier->success("Unlinked Church \"{$event->church->name}\" from Member \"{$event->member->name}\"");
    }
}
