<div class="table-responsive">
    <table class="table table table-striped display" cellspacing="0" width="100%">
        <thead>
            <tr>
                <th>Address Line 1</th>
                <th>City</th>
                <th>Postcode</th>
                <th>Primary</th>
                <th>Last Updated</th>
                <th></th>
            </tr>
        </thead>

        @foreach($member->addresses as $address)
            <tr>
                <td>{{ $address->address_line1 }}</td>
                <td>{{ $address->city }}</td>
                <td>{{ $address->postcode }}</td>
                <td>
                    @if($address->primary)
                        <span class="glyphicon glyphicon-ok text-success" aria-hidden="true"></span>
                    @endif
                </td>
                <td>{{ $address->updated_at }}</td>
                <td data-display="{{ $address->id }}">
                    @if(!$address->primary)
                        {{--                        <a href="{{ route('members.addresses.show', ['id' => $address->id]) }}">make primary</a> |--}}
                    @endif
                    <a class="btn btn-default btn-xs"
                       href="{{ route('members.addresses.show', [$member->id, $address->id]) }}" data-toggle="modal"
                       data-target="#modal">
                        <i class="fa fa-eye" data-toggle="tooltip" data-placement="top" title="View address"></i>
                    </a>
                    <a class="btn btn-default btn-xs"
                       href="{{ route('members.addresses.edit', [$member->id, $address->id]) }}" data-toggle="modal"
                       data-target="#modal">
                        <i class="fa fa-pencil" data-toggle="tooltip" data-placement="top" title="Edit address"></i>
                    </a>
                    <a class="btn btn-default btn-xs"
                       href="{{ route('members.addresses.delete', [$member->id, $address->id]) }}" data-toggle="modal"
                       data-target="#modal">
                        <i class="fa fa-trash" data-toggle="tooltip" data-placement="top" title="Delete address"></i>
                    </a>
                </td>
            </tr>
        @endforeach
    </table>
</div>
<a class="btn btn-default" href="{{ route('members.addresses.create', [$member->id]) }}" data-toggle="modal"
   data-target="#modal">Add Address</a>