<?php namespace DistrictHub\Directory\Http\Controllers;

use DistrictHub\Directory\Http\Requests\RoleRequest;
use DistrictHub\Directory\Jobs\CreateRole;
use DistrictHub\Directory\Jobs\UpdateRole;
use DistrictHub\Contracts\Gateways\Directory\RoleGateway;
use App\Http\Controllers\Controller;
use DistrictHub\Directory\Role;
use Illuminate\Http\Request;

class RoleController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Directory Role Controller
    |--------------------------------------------------------------------------
    */

    /**
     * @var RoleGateway
     */
    protected $roles;

    /**
     * Create a new controller instance.
     *
     * @param RoleGateway $roles
     */
    public function __construct(RoleGateway $roles)
    {
        $this->roles = $roles;

        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @param Requests\Request $request
     *
     * @return Response
     */
    public function index(Request $request)
    {
        $district = Role::district()->ordered()->get();
        $circuit = Role::circuit()->ordered()->get();
        $church = Role::church()->ordered()->get();

        if ($request->wantsJson()) {
            return response()->json(compact('district', 'circuit', 'church'));
        }

        return view('directory::roles.index', compact('district', 'circuit', 'church'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        return view('directory::roles.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \DistrictHub\Directory\Http\Requests\RoleRequest $request
     *
     * @return \DistrictHub\Directory\Http\Controllers\Response
     */
    public function store(RoleRequest $request)
    {
        $this->dispatch(new CreateRole($request->only([
            'name',
            'scope',
        ])));

        return redirect(route('roles.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $role = $this->roles->find($id);

        return view('directory::roles.show', compact('role'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $role = $this->roles->find($id);

        return view('directory::roles.edit', compact('role'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int                                             $id
     * @param \DistrictHub\Directory\Http\Requests\RoleRequest $request
     *
     * @return \DistrictHub\Directory\Http\Controllers\Response
     */
    public function update($id, RoleRequest $request)
    {
        $this->dispatch(new UpdateRole($id, $request->all()));

        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy(Role $role)
    {
        $role->delete();
    }

    public function sort()
    {
        Role::setNewOrder(request('order'));
    }
}
