<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

Route::get('circuits/import', ['as' => 'circuits.import', 'uses' => 'CircuitController@import']);
Route::post('circuits/import', ['as' => 'circuits.extract', 'uses' => 'CircuitController@extract']);
Route::get('circuits/export', ['as' => 'circuits.export', 'uses' => 'CircuitController@export']);

Route::get('churches/import', ['as' => 'churches.import', 'uses' => 'ChurchController@import']);
Route::post('churches/import', ['as' => 'churches.extract', 'uses' => 'ChurchController@extract']);
Route::get('churches/export', ['as' => 'churches.export', 'uses' => 'ChurchController@export']);

Route::get('members/import', ['as' => 'members.import', 'uses' => 'MemberController@import']);
Route::post('members/import', ['as' => 'members.extract', 'uses' => 'MemberController@extract']);
Route::get('members/export', ['as' => 'members.export', 'uses' => 'MemberController@export']);

Route::put('circuits/{circuit}/role-groups/sort', 'CircuitRoleGroupsController@sort');
Route::get('circuits/{circuit}/directory/{directory}/print', 'CircuitDirectoryController@print')->name('circuits.directory.print');

Route::resources([
    'districts' => 'DistrictController',
    'circuits'  => 'CircuitController',
    'churches'  => 'ChurchController',
    'members'   => 'MemberController',
    'circuits.role-groups'  => 'CircuitRoleGroupsController',
    'circuits.role-groups.roles'  => 'CircuitRolesController',
    'circuits.directory' => 'CircuitDirectoryController',
]);

Route::get(
    'churches/{churches}/delete',
    ['as' => 'churches.delete', 'uses' => 'ChurchController@delete']
);

Route::patch(
    'members/{members}/verify',
    ['as' => 'members.verify', 'uses' => 'MemberController@verify']
);

Route::get(
    'members/{members}/delete',
    ['as' => 'members.delete', 'uses' => 'MemberController@delete']
);

Route::resources([
    'churches.addresses' => 'AddressController',
    'churches.phones'    => 'PhoneController',
    'churches.emails'    => 'EmailController',
]);

Route::resources([
    'members.addresses' => 'AddressController',
    'members.phones'    => 'PhoneController',
    'members.emails'    => 'EmailController',
]);

Route::get(
    'members/{members}/addresses/{addresses}/delete',
    ['as' => 'members.addresses.delete', 'uses' => 'AddressController@delete']
);
Route::get(
    'members/{members}/phones/{phones}/delete',
    ['as' => 'members.phones.delete', 'uses' => 'PhoneController@delete']
);
Route::get(
    'members/{members}/emails/{emails}/delete',
    ['as' => 'members.emails.delete', 'uses' => 'EmailController@delete']
);

Route::patch(
    'members/{members}/roles',
    ['as' => 'members.roles.assign', 'uses' => 'MemberController@assign']
);
Route::get(
    'members/{members}/roles/{roles}',
    ['as' => 'members.roles.remove', 'uses' => 'MemberController@remove']
);

Route::patch(
    'members/{members}/churches',
    ['as' => 'members.churches.link', 'uses' => 'MemberController@linkChurch']
);
Route::get(
    'members/{members}/churches/{churches}',
    ['as' => 'members.churches.unlink', 'uses' => 'MemberController@unlinkChurch']
);

Route::put('roles/sort', 'RoleController@sort');

Route::resources(['roles' => 'RoleController']);
