<?php namespace DistrictHub\Directory\Jobs;

use DistrictHub\Directory\Circuit;
use DistrictHub\Directory\Events\CircuitWasCreated;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class CreateCircuit implements ShouldQueue
{
    use InteractsWithQueue, Queueable, SerializesModels;

    protected $attributes;

    /**
     * Create a new command instance.
     *
     * @param int   $id
     * @param array $attributes
     *
     * @return void
     */
    public function __construct(array $attributes)
    {
        $this->attributes = $attributes;
    }

    /**
     * Execute the command.
     *
     * @return void
     */
    public function handle()
    {
        $circuit = Circuit::create($this->attributes);

        event(new CircuitWasCreated($circuit));
    }
}
