<?php namespace DistrictHub\Directory\Gateways;

use DistrictHub\Contracts\Gateways\Directory\MemberTitleGateway as MemberTitleGatewayContract;
use DistrictHub\Directory\Gateways\CachedGateway;
use Illuminate\Contracts\Cache\Repository as Cache;

/**
 * CachedMemberTitleGateway.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 * @package      App\Gateways\Directory
 */
class CachedMemberTitleGateway extends CachedGateway implements MemberTitleGatewayContract
{
    /**
     * @var MemberTitleGatewayContract
     */
    private $gateway;

    /**
     * Create new gateway instance.
     *
     * @param MemberTitleGatewayContract $gateway
     * @param Cache                      $cache
     *
     */
    public function __construct(MemberTitleGatewayContract $gateway, Cache $cache)
    {
        parent::__construct($cache);
        $this->gateway = $gateway;
    }

    /**
     * Get array of ids/values for use in select fields.
     *
     * @param string $valueColumn
     * @param string $idColumn
     * @param string $default
     *
     * @return array
     */
    public function options($valueColumn, $idColumn = 'id', $default = '-- Select --')
    {
        return $this->remember(
            $this->cacheKey(__METHOD__, func_get_args()),
            function () use ($valueColumn, $idColumn, $default) {
                return $this->gateway->options($valueColumn, $idColumn, $default);
            }
        );
    }
}
