<?php namespace DistrictHub\Directory\Gateways;

use DistrictHub\Contracts\Gateways\Directory\MemberGateway as MemberGatewayContract;
use DistrictHub\Directory\Gateways\Gateway;
use DistrictHub\Directory\Member;

/**
 * MemberEloquentGateway.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 * @package      App\Gateways\Directory
 */
class MemberGateway extends Gateway implements MemberGatewayContract
{
    /**
     * @var string FQCN of model.
     */
    protected $model = Member::class;

    /**
     * Search records with fields and sort with order.
     *
     * @param array $fields
     * @param array $order
     *
     * @return \Illuminate\Database\Eloquent\Collection|static[]
     */
    public function search(array $fields, array $order)
    {
        // Start query
        $members = $this->model()->select('directory_members.*')
                        ->leftJoin('directory_circuits as circuit', 'directory_members.circuit_id', '=', 'circuit.id')
                        ->leftJoin('directory_member_types as type', 'directory_members.type_id', '=', 'type.id')
                        ->leftJoin('directory_member_role as roles', 'directory_members.id', '=', 'roles.member_id');

        // Searching
        foreach ($fields as $field => $value) {
            if (!empty($value)) {
                $members = $members->where($field, $value);
            }
        }

        // Ordering
        if (!empty($order)) {
            foreach ($order as $orderBy) {
                $members = $members->orderBy($orderBy['column'], $orderBy['dir']);
            }
        } else {
            $members = $members
                ->orderBy('last_name', 'asc')
                ->orderBy('first_name', 'asc');
        }

        // Get query results
        return $members->with('circuit', 'type')->distinct()->get();
    }

    /**
     * Get the total number of records.
     *
     * @return int
     */
    public function total()
    {
        return $this->model()->count();
    }

    /**
     * Find a model by its primary key.
     *
     * @param  mixed $id
     *
     * @return \DistrictHub\Directory\Member|null
     */
    public function find($id)
    {
        return $this->model()->find($id);
    }

    /**
     * Update a model with the specified primary key.
     *
     * @param int   $id
     * @param array $attributes
     *
     * @return bool
     */
    public function update($id, array $attributes)
    {
        $model = $this->model()->find($id)->fill($attributes);

        if ($model->save()) {
            return true;
        }

        return false;
    }
}
