<?php namespace DistrictHub\Directory\Http\Controllers;

use League\Csv\Writer;
use SplTempFileObject;

/**
 * ExportsCsv.
 *
 * @author  Tom Densham <nedmas@mavenfortytwo.co.uk>
 * @package DistrictHub\Directory\Http\Controllers
 */
trait ExportsCsv
{
    /**
     * Generate CSV file from $data showing only $columns with the name $filename.
     * Optional $formatter callable that processes the inserted data.
     *
     * @param array    $data
     * @param array    $columns
     * @param string   $filename
     * @param callable $formatter
     */
    protected function generateCsv(array $data, array $columns, $filename, callable $formatter = null)
    {
        $csv = Writer::createFromFileObject(new SplTempFileObject());

        $csv->insertOne($columns);

        $csv->addFormatter($formatter);

        $csv->insertAll($data);

        $filename = trim($filename);
        $filename = filter_var($filename, FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW);
        header("Content-Type: application/octet-stream");
        header("Content-Transfer-Encoding: binary");
        header("Content-Disposition: attachment; filename=\"$filename\"");

        return rtrim($csv);
    }
}
