<?php namespace DistrictHub\Directory\Listeners;

use DistrictHub\Directory\Events\MemberAssignedToRole;
use DistrictHub\Support\Listeners\Notification;

class AlertMemberAssignedToRole extends Notification
{
    /**
     * Handle the event.
     *
     * @param  MemberAssignedToRole $event
     *
     * @return void
     */
    public function handle(MemberAssignedToRole $event)
    {
        $this->notifier->success("Assigned Member \"{$event->member->name}\" the Role \"{$event->role->name}\"");
    }
}
