<?php namespace DistrictHub\Directory;

use Illuminate\Database\Eloquent\Model;

class MemberType extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'directory_member_types';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'description',
    ];

    /**
     * The related Member models.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function members()
    {
        return $this->hasMany(Member::class);
    }
}
