<?php namespace DistrictHub\Directory;

use Illuminate\Database\Eloquent\Model;

class PhoneType extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'directory_phone_types';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'description',
    ];

    /**
     * The related Phone models.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function phones()
    {
        return $this->hasMany(Phone::class);
    }
}
