<?php namespace DistrictHub\Directory\Providers;

use DistrictHub\Contracts\Gateways\Directory\ChurchGateway;
use DistrictHub\Contracts\Gateways\Directory\CircuitGateway;
use DistrictHub\Contracts\Gateways\Directory\MemberGateway;
use DistrictHub\Contracts\Gateways\Directory\MemberTitleGateway;
use DistrictHub\Contracts\Gateways\Directory\MemberTypeGateway;
use DistrictHub\Contracts\Gateways\Directory\RoleGateway;
use DistrictHub\Directory\Gateways\CachedChurchGateway;
use DistrictHub\Directory\Gateways\CachedCircuitGateway;
use DistrictHub\Directory\Gateways\CachedMemberGateway;
use DistrictHub\Directory\Gateways\CachedMemberTitleGateway;
use DistrictHub\Directory\Gateways\CachedMemberTypeGateway;
use DistrictHub\Directory\Gateways\ChurchGateway as EloquentChurchGateway;
use DistrictHub\Directory\Gateways\CircuitGateway as EloquentCircuitGateway;
use DistrictHub\Directory\Gateways\MemberGateway as EloquentMemberGateway;
use DistrictHub\Directory\Gateways\MemberTitleGateway as EloquentMemberTitleGateway;
use DistrictHub\Directory\Gateways\MemberTypeGateway as EloquentMemberTypeGateway;
use DistrictHub\Directory\Gateways\RoleGateway as EloquentRoleGateway;
use Illuminate\Support\ServiceProvider;

class GatewayServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton(ChurchGateway::class, function () {
            return new EloquentChurchGateway();
        });
        $this->app->singleton(CircuitGateway::class, function () {
            return new EloquentCircuitGateway();
        });
        $this->app->singleton(MemberTitleGateway::class, function () {
            return new EloquentMemberTitleGateway();
        });
        $this->app->singleton(MemberTypeGateway::class, function () {
            return new EloquentMemberTypeGateway();
        });
        $this->app->singleton(MemberGateway::class, function () {
            return new EloquentMemberGateway();
        });
        $this->app->singleton(RoleGateway::class, function () {
            return new EloquentRoleGateway();
        });
    }
}
