<?php namespace DistrictHub\Directory\Services;

use Illuminate\Contracts\Mail\Mailer;
use Illuminate\Mail\Message;

/**
 * Messenger.
 *
 * @author       Tom Densham <tom.densham@studiobonito.co.uk>
 * @copyright    Studio Bonito Ltd.
 * @package      App\Services
 */
class Messenger
{
    /**
     * @var Mailer
     */
    private $mailer;

    /**
     * @param Mailer $mailer
     */
    public function __construct(Mailer $mailer)
    {
        $this->mailer = $mailer;
    }

    /**
     * @param string $sender
     * @param string $recipient
     * @param string $message
     */
    public function message($sender, $recipient, $message)
    {
        $data = [
            'from'    => $sender,
            'content' => $message,
        ];

        $this->mailer->send('emails.message', $data, function (Message $message) use ($recipient) {
            $message->to($recipient);
        });
    }
}
