<?php namespace DistrictHub\Directory\Jobs;

use DistrictHub\Directory\Member;
use DistrictHub\Directory\Events\MemberWasCreated;
use Illuminate\Contracts\Queue\ShouldQueue;

class CreateMember implements ShouldQueue
{
    protected $attributes;

    /**
     * Create a new command instance.
     *
     * @param int   $id
     * @param array $attributes
     *
     * @return void
     */
    public function __construct(array $attributes)
    {
        $this->attributes = $attributes;
    }

    /**
     * Execute the command.
     *
     * @return void
     */
    public function handle()
    {
        $member = Member::create($this->attributes);

        event(new MemberWasCreated($member));
    }
}
